#import packages

import numpy as np
import cvxpy as cp

#CVXPY allows also to introduces optimization variables that are vectors or matrices
#the argument denotes the dimension

x = cp.Variable()
y = cp.Variable()

obj = cp.Minimize(x)

#an example of an infeasible problem

constr1 = [0<=x, x<=-1]
prob1 = cp.Problem(obj,constr1) 

#We solve the problem
print('We defines Problem 1 as:')
print(prob1)
result1 = prob1.solve()

#Print the solution
print('')
print('The status of Problem 1 is', prob1.status)
print('The optimal value of Problem 1 is', prob1.value)
print('The optimal solution to Problem 1 is x =', x.value, 'y =', y.value)

#an example of an unbounded problem

constr2 = [x<=-1,y==0]
prob2 = cp.Problem(obj,constr2) 

#We solve the problem
print('')
print('We defines Problem 2 as:')
print(prob2)
result = prob2.solve()

#Print the solution
print('')
print('The status of Problem 2 is', prob2.status)
print('The optimal value of Problem 2 is', prob2.value)
print('The optimal solution to Problem 2 is x =', x.value, 'y =', y.value)


#an example of a problem with not unique solutions

constr3 = [x>=-1,0<=y, y<=1000]
prob3 = cp.Problem(obj,constr3) 

#We solve the problem
print('')
print('We defines Problem 3 as:')
print(prob3)
result = prob3.solve()

#Print the solution
print('')
print('The status of Problem 3 is', prob3.status)
print('The optimal value of Problem 3 is', prob3.value)
print('An optimal solution to Problem 3 is x =', x.value, 'y =', y.value)
print('Note that only one among many optimal solution is returned.')

#What happens if we solve Problem 1 again?
result1 = prob1.solve()

#Print the solution
print('')
print('This is the output we get, if we run the solver on Problem 1 again:')
print('The status of Problem 1 is', prob1.status)
print('The optimal value of Problem 1 is', prob1.value)
print('The optimal solution to Problem 1 is x =', x.value, 'y =', y.value)
print('Note that the value of y was not overwritten. For clean programming, I would recommended not to reuse variables/problems etc.')
