program shift_convfile
  implicit none
  character(len=50) :: datfile, convfile, texfile, texfile2, texfile3
  integer:: i, j,  nmax ,nn,  dmax, idat, itex, iconv1, iconv2
  real :: h, tau , rshift, tshift, eshift
  real, dimension(:,:), allocatable :: w, r
  integer, dimension(:,:), allocatable :: wi, ri
  logical :: iprint
  
  iconv1 = 11
  iconv2 = 12
  itex = 13
  if (command_argument_count() == 5) then
     call get_command_argument(1,datfile)
     open(iconv1, file=datfile, status='OLD')

     call get_command_argument(2,convfile)
     open(iconv2, file=convfile, status='unknown')
     
     call get_command_argument(3,texfile)
     call get_command_argument(4,texfile2)
     call get_command_argument(5,texfile3)

     open(itex, file="1.dat", status='unknown')
     write(itex, *) texfile
     write(itex, *) texfile2
     write(itex, *) texfile3
     close(itex)

     open(itex, file="1.dat", status='OLD')
     read(itex, *) rshift
     read(itex, *) tshift
     read(itex, *) eshift
     close(itex)
     print*,'rshift = ', rshift,',  tshift = ', tshift,',  eshift = ', eshift
     
  else
     print *, "sytax:  shift_convfile <input_file> <output_convfile> <rshift>  <start_shift> <end_shift>"
     stop
  endif
  
  nmax = 2
  dmax = 60

  allocate(w(1:nmax, 1:dmax),  wi(1:nmax, 1:dmax) )


  i = 1
  nn = 0
  
  do j=1,100000
     read(iconv1, *, end = 110) wi(i,1), w(i, 2:17), wi(i,18:19), w(i, 20), wi(i,21), &
          w(i,22:26), wi(i, 27), w(i,28:52), wi(i,53), w(i, 54:58), wi(i,59)

     if(j > 1) then
        if(wi(i, 53) < wi(2, 53) ) write(iconv2, '(x)')  ! new mesh adaptation
     endif
     if(w(i,3) > tshift) then
        w(i,3) = w(i,3) + rshift
     endif

     if( w(i,3)  <= eshift ) then
        write(iconv2,'(i6,16es14.6, i5,i8, es14.6, i5,  5es12.4, i6, 25es14.6, i8, 5es16.6, i5)') &
             wi(i,1), w(i, 2:17), wi(i,18:19), w(i, 20), wi(i,21), &
             w(i,22:26), wi(i, 27), w(i,28:52), wi(i,53), w(i, 54:58), wi(i,59)
     endif
     
     w(2, :) = w(1, :)
     wi(2, :) = wi(1, :)
     
     nn = nn + 1
  enddo

110  continue

  print*,'Number of changed lines = ', nn

  deallocate(w, wi)

  close(iconv1)
  close(iconv2)


end program shift_convfile
