program read_data
  real, dimension(:,:), allocatable :: w

  allocate( w(1:20, 1:3))

  idat = 11
  itex = 12

  open(idat, file = '1.dat', status= 'UNKNOWN')

  read(idat, *) w(1:20, 1)  ! NS
  read(idat, *) w(1:20, 2)  ! Eul
  read(idat, *) w(1:20, 3)  ! Eul

  open(itex, file = '1.tex', status= 'UNKNOWN')

  !write(itex, *) '\vspace{-50mm}'
  !write(itex, *) 'Aerodynamics coefficients'
  write(itex, *) '{\footnotesize '
  write(itex, *) '\begin{tabular}{c|ccc}'
  write(itex, *) '\hline'
  write(itex, *) ' & $ c_D$ & $c_L$ & $c_M$ \\'
  write(itex, *) '\hline'
  write(itex, *) '{\NSe} ' 
  write(itex, 20) w(8:10, 1)
  write(itex, *) ' {\Eul}, $\alpha=1$  '
  write(itex, 20) w(8:10, 2) 
  write(itex, *) ' {\Eul}, $\alpha=4/3$  '
  write(itex, 20) w(8:10, 3) 
  write(itex, *) '\hline'
  write(itex, *) '$\Delta(${\NSe}\ ; \ {\Eul}\,$\alpha=1)$  '
  write(itex, 20) abs(w(8:10, 1) - w(8:10,2)) / max(abs(w(8:10,1)), abs(w(8:10,2)))
  write(itex, *) '$\Delta(${\NSe}\ ; \  {\Eul}\,$\alpha=4/3)$  '
  write(itex, 20) abs(w(8:10, 1) - w(8:10,3)) / max(abs(w(8:10,1)), abs(w(8:10,3)))
  write(itex, *) '$\Delta(${\Eul}\,$\alpha=1$\ ; \ {\Eul}\,$\alpha=4/3) $ '
  write(itex, 20) abs(w(8:10, 3) - w(8:10,2)) / max(abs(w(8:10,3)), abs(w(8:10,2)))
  write(itex, *) '\hline'

  write(itex, *) '\end{tabular}'
  write(itex, *) '}'
20 format( 3(' & ' '\numf{' f12.7 '}' ) '\\')

  

end program read_data
