#!/bin/csh

if (  $#argv != 2) then
   echo '    '
   echo 'Syntax:  make_gnuplot_latex.sh  <in_file>   <out_file> '
   echo 'Example:  make_gnuplot_latex.sh  1 fig.pdf'
else

#echo '##############################################'
echo 'make_gnuplot_latex.sh '  $argv[1] '    '    $argv[2]

  set file=$argv[1]
  set fig=$argv[2]

  epstopdf $file.eps

  
cat << EOF > tiskA.tex
\documentclass{article}
\usepackage{graphics}
\usepackage{nopageno}
\usepackage{txfonts}
\usepackage{amssymb}
\usepackage{mathrsfs}
%\usepackage{amsmath}

\usepackage{bm}             % boldface symbols (\bm)
\usepackage[usenames]{color}
%\setlength{\pagewidth}{4.7in}
%\setlength{\pageheight}{3.4in}
%\hoffset -2.1in
%\voffset -3.8in

\input{def.tex}

\begin{document}
\begin{center}
\input{$file.tex}
\end{center}
\end{document}
EOF

#echo "performing >  pdflatex tiskA.tex > smaz ..."
pdflatex tiskA.tex #> smazY
pdfcrop tiskA.pdf #> smazZ

mv tiskA-crop.pdf $fig

#rm -f tiskA.tex tiskA.pdf $file.pdf smaz

endif
