program extract_orderfile
  implicit none
  character(len=50) :: datfile, convfile, texfile,  name
  integer:: i, j,  nmax ,nn,  dmax, idat, itex0, iconv, itype, loops
  real :: h, tau , total, rtime
  real, dimension(:,:), allocatable :: w, r
  integer, dimension(:,:), allocatable :: wi, ri
  logical :: iprint

  itype = 10  ! errors
  itype = 11  ! relative computational times
  
  idat = 11
  iconv = 12
  itex0 = 13
  if (command_argument_count() == 2) then
     call get_command_argument(1,datfile)
     open(idat, file=datfile, status='OLD')

     call get_command_argument(2,texfile)
     open(itex0, file=texfile, status='unknown')
     

  else
     print *, "sytax:  extract_orderfile <datfile>  <file.tex>"
     stop
  endif
  
  nmax = 10000
  dmax = 100

  allocate(w(1:nmax, 1:dmax),  wi(1:nmax, 1:dmax) )
  allocate(r(1:nmax, 1:dmax),  ri(1:nmax, 1:dmax) )

  nn = 0
  ! order.dat file
  do i=1,nmax
     read(idat, *, end = 120) ri(i,1), r(i, 2:3), ri(i,4), r(i,5:78)
     nn = nn + 1
     write(*,'(2i7, 16es12.4)') i, ri(i, 4), r(i, 71), r(i, 73:77), sum(r(i, 73:77) )
  enddo
120 continue

  

  if(itype == 11) then
     write(itex0, *) '{ \small '
    write(itex0, *) '\setlength{\tabcolsep}{6pt}'
     write(itex0, *) '\begin{tabular}{l|crc|ccccc|c}'
     write(itex0, *) '\hline'
     write(itex0, *) ' & \multicolumn{3}{|c}{} & \multicolumn{6}{|c}{relative distribution of computational times} \\'
     write(itex0, *) '\cline{5-10}'

     write(itex0, *) ' case &  loops& $\DoF$ &time(s) & prepare  & solve & recons & estim & adapt  & total \\'
     write(itex0, *) '\hline'

     do i=1, nn
        if(i == 1) then
           name = "quasi-linear elliptic, \S~\ref{sec:numQ}"
           rtime = 158.3
           loops = 25
        elseif(i == 2) then
           name = "convection-diffusion, \S~\ref{sec:numB}"
           rtime = 304.5
           loops = 10
        elseif(i == 3) then
          rtime = 133.3
           name = "NACA, drag coeff., \S~\ref{sec:nac_subCD}"
           loops = 8
        elseif(i == 4) then
          rtime = 829.9
           name = "NACA, lift coeff., \S~\ref{sec:nac_subCL}"
           loops = 12
        endif
        
        total = sum(r(i, 73:77) )

        r(i, 73:77) = r(i, 73:77) / total*100
        write(itex0, 200) name, loops, ri(i,4), rtime, r(i, 73:74), r(i, 77), r(i,75:76), 100.
     end do

     write(itex0, *) '\hline'



     write(itex0, *) '\end{tabular}'
     write(itex0, *) ' }'



  else if(itype == 10) then
     write(itex0, *) '{ %\scriptsize}'

     write(itex0, *) '\setlength{\tabcolsep}{10pt}'
     write(itex0, *) '\begin{tabular}{c|cr|ccc}'
     write(itex0, *) '\hline'

     write(itex0, *) ' mesh & $h$ & $\#\Th$\ \  '
     write(itex0, *) '& $\norm{\eh}{L^2(\Omega)}$ & $\snorm{\eh}{H^1(\Omega)}$' , &
          '& $\norm{\eh}{L^\infty(\Omega)}$ \\'
     write(itex0, *) '\hline'
     !  write(itex0, *) '\multicolumn{5}{c}{uniform meshes} \\'
     !  write(itex0, *) '\hline'


     do i=1, nn
        if(i <= 2) then 
           write(itex0, *) 'uniform &'
           h = 1./sqrt(1.*ri(i,1)/2)
        else
           write(itex0, *) 'anisotropic &'
           h = 1./(1.*ri(i,1)/2)
        end if
        write(itex0,300) h, ri(i,1) , r(i, 11:12), r(i, 26) !71) !26)
        if(i == 2)  write(itex0, *) '\hline'

     end do

     write(itex0, *) '\hline'



     write(itex0, *) '\end{tabular}'
     write(itex0, *) ' }'
  endif

  300 format ( f8.3 ' & ' i6, 3('& ', es12.4) '\\')
  200 format ( a50, '&' 2( i8 '&'), f10.1 , 6('& ', f10.1'\%') '\\')

  deallocate(w, wi, r, ri)
  close(idat)

  close(itex0)


end program extract_orderfile
