! GLOBAL, comparing models NSe, Eul1, Eul2, 
program extract_convfile
  implicit none
  character(len=50) :: datfile1, datfile2, datfile3
  character(len=50) :: texfile1, texfile2, texfile3, texfile
  integer:: i, j,  nmax ,nn,  cmax, mmax, idat1, idat2, idat3, itex1,itex2,itex3, itex0
  real :: h, tau 
  real, dimension(:,:, :), allocatable :: w 
  integer, dimension(:,:, :), allocatable :: wi
  logical :: iprint
  
  idat1 = 11
  idat2 = 12
  idat3 = 13
  itex0 = 20
  itex1 = 21
  itex2 = 22
  itex3 = 23
  if (command_argument_count() == 4) then
     call get_command_argument(1,datfile1)
     open(idat1, file=datfile1, status='OLD')

     call get_command_argument(2,datfile2)
     open(idat2, file=datfile2, status='OLD')

     call get_command_argument(3,datfile3)
     open(idat3, file=datfile3, status='OLD')

     ! call get_command_argument(4,texfile1)
     ! open(itex1, file=texfile1, status='unknown')
     
     ! call get_command_argument(5,texfile2)
     ! open(itex2, file=texfile2, status='unknown')
     
     ! call get_command_argument(6,texfile3)
     ! open(itex3, file=texfile3, status='unknown')
     
     call get_command_argument(4,texfile)
     open(itex0, file=texfile, status='unknown')
     

  else
     print *, "syntax:  extract_convfileG <datfile1> <datfile2> <datfile3>", &
          "  <file.tex>"
     !          " <file1.tex> <file2.tex> <file3.tex>  <file.tex>"
     stop
  endif
  
  nmax = 1000
  cmax = 3
  mmax = 3
  
  allocate(w(1:mmax, 1:cmax, -1:nmax), wi(1:mmax, 1:cmax, 1:nmax) )


  ! order.dat file
  nn = 0
  do i=1,nmax
     read(idat1, *, end = 120) j, wi(1, 1, i), w(1, 1:3, i)
     read(idat2, *, end = 120) j, wi(2, 1, i), w(2, 1:3, i)
     read(idat3, *, end = 120) j, wi(3, 1, i), w(3, 1:3, i)
     nn = nn + 1
  enddo
120 continue

  ! relative difference
  do i=1,3 ! model
     do j=1,3 ! coeffs
        w(i, j, 0) = abs(w(i, j, nn) - w(1, j, nn)) /abs( w(1, j, nn) )     ! model error
        w(i, j, -1) = abs(w(i, j, nn) - w(i, j, nn-1)) /abs( w(i, j, nn) )  ! comput error
     enddo
  enddo
  
        
  ! do j=1, 3

  !    write(itex0+j, *) '{\footnotesize '
  !    write(itex0+j, *) '\setlength{\tabcolsep}{2pt}'
  !    write(itex0+j, *) '\begin{tabular}{c|r|ccc}'
  !    write(itex0+j, *) '\hline'

  !    select case(j)
  !    case(1)
  !       write(itex0+j, *) '\multicolumn{5}{c}{drag coefficient $c_D$} \\'
  !    case(2)
  !       write(itex0+j, *) '\multicolumn{5}{c}{lift coefficient $c_L$ }\\'
  !    case(3)
  !       write(itex0+j, *) '\multicolumn{5}{c}{moment coefficient $c_M$} \\'
  !    end select
      
  !    write(itex0+j, *) '\hline'
  !    write(itex0+j, *) '$\ell$ & $\DoF$\ \  & {\NSe} & {\Eul} & {\Eul}  \\ [-4pt]'
  !    write(itex0+j, *) '  &  &  &  $\alpha=1$ & $\alpha=4/3$ \\ [-2pt]'
  !    write(itex0+j, *) '\hline'
     
  !    do i=1, nn
  !       write(itex0+j,200) i, wi(j, 1, i), w(1:3, j, i)
  !    end do

  !    write(itex0+j, *) '\hline'
  !    write(itex0+j, *) '\end{tabular}'
  !    write(itex0+j, *) ' }'

  ! enddo



  write(itex0, *) '{\footnotesize '
  write(itex0, *) '\setlength{\tabcolsep}{2pt}'
  write(itex0, *) '\begin{tabular}{c|r|ccc|ccc|ccc}'
  write(itex0, *) '\hline'

  write(itex0, *) ' \multicolumn{2}{c|}{} & '
  write(itex0, *) '\multicolumn{3}{c|}{drag coefficient $c_D$} &'
  write(itex0, *) '\multicolumn{3}{c|}{lift coefficient $c_L$ } &'
  write(itex0, *) '\multicolumn{3}{c}{momentum coefficient $c_M$} \\'
      
  write(itex0, *) '\hline'
  write(itex0, *) '$\ell$ & $\DoF$\ \  '
  write(itex0, *) '& {\NSe} & {\Eul} & {\Eul} '
  write(itex0, *) '& {\NSe} & {\Eul} & {\Eul} '
  write(itex0, *) '& {\NSe} & {\Eul} & {\Eul} '
  write(itex0, *) '\\ [-4pt]'
  write(itex0, *) '  &  '
  write(itex0, *) ' &  & $\alpha=1$ & $\alpha=4/3$'
  write(itex0, *) ' &  & $\alpha=1$ & $\alpha=4/3$'
  write(itex0, *) ' &  & $\alpha=1$ & $\alpha=4/3$'
  write(itex0, *) ' \\ [-2pt]'
  write(itex0, *) '\hline'
  
  do i=1, nn
     write(itex0,300) i, wi(1, 1, i), w(1:3, 1, i), w(1:3, 2, i), w(1:3, 3, i)
  end do

  write(itex0, *) '\hline'

  write(itex0, *) ' \multicolumn{2}{c|}{$e_h^{\mathrm{comput}}$}  '
  write(itex0,400) w(1:3,1,-1), w(1:3,2,-1), w(1:3,3,-1)

  write(itex0, *) ' \multicolumn{2}{c|}{$e_h^{\mathrm{model}}$}  '
  write(itex0,500) w(2:3,1,0), w(2:3,2,0), w(2:3,3,0)

  
  write(itex0, *) '\hline'


  
  write(itex0, *) '\end{tabular}'
  write(itex0, *) ' }'


  
200  format(i5, ' & ', i8, 3( ' & ', es14.5) ' \\')
300  format(i5, ' & ', i8, 9( ' & ', es14.5) ' \\')
400  format( 3(  3('& ', es11.3) ) ' \\')
500  format( 3( ' & -- ', 2('& ', es11.3) ) ' \\')
  
  deallocate(w, wi)
  close(idat1)
  close(idat2)
  close(idat3)

!  close(itex1)
!  close(itex2)
!  close(itex3)
  close(itex0)


end program extract_convfile
