program extract_orderfile
  implicit none
  character(len=50) :: datfile1, datfile2, datfile3, convfile, texfile, gnufile
  integer:: i, j,  nmax ,nn,  dmax, idat0, idat1, idat2, idat3, itex0, itex1, iconv, pk, dk, pkold
  real :: h, tau , r1,r2, r3, hold
  real, dimension(:,:), allocatable :: w, r
  integer, dimension(:,:), allocatable :: wi, ri
  logical :: iprint

  idat0 = 0
  idat1 = idat0 + 1
  idat2 = idat0 + 2
  idat3 = idat0 + 3

  iconv = 12
  itex0 = 13
  itex1 = 14
  if (command_argument_count() == 4) then
     call get_command_argument(1,datfile1)
     open(idat1, file=datfile1, status='OLD')

     call get_command_argument(2,datfile2)
     open(idat2, file=datfile2, status='OLD')

     call get_command_argument(3,datfile3)
     open(idat3, file=datfile3, status='OLD')

     call get_command_argument(4,texfile)
     open(itex0, file=texfile, status='unknown')


  else
     print *, "sytax:  extract_orderfile <datfile>  <file.tex>"
     stop
  endif
  
  nmax = 10000
  dmax = 100

  allocate(w(1:nmax, 1:dmax),  wi(1:nmax, 1:dmax) )
  allocate(r(1:nmax, 1:dmax),  ri(1:nmax, 1:dmax) )

  nn = 0
  do j=1,3
  ! order.dat file
     do i=1,nmax
        nn = nn + 1
        read(idat0+j, *, end = 120) ri(nn,1:3), r(nn, 4), ri(nn,5:6), r(nn,7:40)
        !write(*,*) nn, ri(nn,1:3), r(nn, 4)
     enddo
120  continue
     nn = nn - 1
  enddo
  
  write(itex0, *) '{ %\scriptsize}'

  write(itex0, *) '\setlength{\tabcolsep}{4pt}'
  write(itex0, *) '\begin{tabular}{c|c|cc|cc|cc}' !|cc}'
  write(itex0, *) '\hline'

  write(itex0, *) ' $p$ & $h$ &'
!  write(itex0, *) ' $J(u)-J_h(u_h)$ & (EOC) &'
  write(itex0, *) ' $ e_h $ & (EOC) &'
  write(itex0, *) ' $\etaI$  & (EOC) & '
  write(itex0, *) ' $\etaII$ & (EOC) \\ '
  write(itex0, *) '\hline'
!  write(itex0, *) '\multicolumn{5}{c}{uniform meshes} \\'
!  write(itex0, *) '\hline'

  pkold = 0
  do i=1, nn
     h = 1. / sqrt(1.*ri(i,2))
     !print*,'h=', h, i, nn, ri(i,2)
     dk = ri(i,3)/ ri(i,2)

     pk = ( int(sqrt(9.001+8*(dk-1))) - 3 ) / 2

     if(i == 1 .or. pk /= pkold) then
        if(pk /= pkold)  write(itex0, *) '\hline'
        write(itex0, 300) pk, h, r(i,15) , r(i, 31), r(i, 11) !, & !71) !26)
        !r(i, 31) /r(i,15), r(i, 11) /r(i,15)
     else
        r1 = log(  r(i,15) /  r(i-1 ,15) ) / log( h/ hold)
        r2 = log(  r(i,31) /  r(i-1 ,31) ) / log( h/ hold)
        r3 = log(  r(i,11) /  r(i-1 ,11) ) / log( h/ hold)

        write(itex0, 301) pk, h, r(i,15) , r1, r(i, 31), r2, r(i, 11), r3 !, &
         !    r(i, 31) /r(i,15), r(i, 11) /r(i,15)
     endif

     hold = h
     pkold = pk
     write(100+pk, *) h, r(i,15) , r(i, 31), r(i, 11)
     
  end do

  write(itex0, *) '\hline'


  
  write(itex0, *) '\end{tabular}'
  write(itex0, *) ' }'

300 format ( i3, '&', es10.2,  3('& ', es12.3, '& -- ') '\\' )
301 format ( i3, '&', es10.2,  3('& ', es12.3, '& (', f5.2, ')' ) '\\' )

400 format ( i3, '&', es10.2,  3('& ', es12.3, '& -- '), 2('&' es10.1) '\\' )
401 format ( i3, '&', es10.2,  3('& ', es12.3, '& (', f5.2, ')' ), 2('&' es10.1) '\\' )

  deallocate(w, wi, r, ri)
  close(idat1)
  close(idat2)
  close(idat3)

  close(itex0)



end program extract_orderfile
