program diff_gnu_file
  implicit none
  character(len=50) :: file1, file2, fileO
  integer:: i, j, k, nmax ,nn,  dmax, ignu1, ignu2, ignu0, iout, ii
  real :: h, tau, sum, val, sum1, val1, x0, h0, hh
  integer, dimension(:), allocatable :: ip
  real, dimension(:,:), allocatable :: x, y
  real, dimension(:,:,:), allocatable ::  xi, yi
  logical :: iprint
  
  ignu0 = 10
  ignu1 = 11
  ignu2 = 12
  iout = 13
  if (command_argument_count() == 3) then
     call get_command_argument(1,file1)
     open(ignu1, file=file1, status='OLD')

     call get_command_argument(2,file2)
     open(ignu2, file=file2, status='OLD')

     call get_command_argument(3,fileO)
     open(iout, file=fileO, status='unknown', position='append')
     

  else
     print *, "sytax:  extract_orderfile <datfile1>  <datfile2> <file_out>"
     stop
  endif
  
  nmax = 10000
  dmax = 100

  allocate(x(1:2, 1:3),  y(0:2, 1:3) )
  allocate(ip(1:2) )
  x = 0.
  y = 0.
  
  nn = 0
  ! order.dat file
  sum = 0.
  sum1 = 0.

  x0 = 5E-05
  h0 = 0.02
  dmax = 8  
  ip = 0

  
  hh = h0 / dmax
  
     sum = 0.
     sum1 = 0.
  do i=1,nmax

     do k=1, 2  ! file index
        read(ignu0+k, *, end = 120) x(k, 1), y(k,1)
        read(ignu0+k, *, end = 120) x(k, 2), y(k,2)
        read(ignu0+k, *, end = 120) x(k, 3), y(k,3)
     enddo
     
     y(0, 1:3) = y(1, 1:3) - y(2, 1:3)
     ! ALL DOMAIN
     if(x(1,1) >= -x0 .and. x(1,3) <= x0 .and. x(1,1) < x(1,3) ) then
     !if( x(1,1) < x(1,3) ) then
           
        h = x(1,3) - x(1,1)
        hh = x(2,3) - x(2,1)
        if(abs(h - hh) > 1E-6) stop "bad hhhh"
        
        ! Simpson
        val  = ( y(0,  1)**2 + 4 * y(0,  2)**2 + y(0,  3)**2) / 6.
        val1 = ( y(1,  1)**2 + 4 * y(1,  2)**2 + y(1,  3)**2) / 6.
        
        val = val * h
        val1 = val1 * h
        
        sum = sum + val
        sum1 = sum1 + val1
        !write(*,'(a8, i5, 40es12.4)' ) '3d3', i,  y(0, 1:3), x(1,1), x(1,3)


     endif
     
  enddo
120 continue
  print*,'#####', sum, sum1, sum/sum1
  write(iout, *) sum/sum1, h
  close(iout)
  
end program diff_gnu_file

