program diff_gnu_file
  implicit none
  character(len=50) :: file1, file2, fileO
  integer:: i, j, k, nmax ,nn,  dmax, ignu1, ignu2, ignu0, iout, ii
  real :: h, tau, sum, val, sum1, val1, x0, h0, hh
  integer, dimension(:), allocatable :: ip
  real, dimension(:,:), allocatable :: x, y
  real, dimension(:,:,:), allocatable ::  xi, yi
  logical :: iprint
  
  ignu0 = 10
  ignu1 = 11
  ignu2 = 12
  iout = 13
  if (command_argument_count() == 3) then
     call get_command_argument(1,file1)
     open(ignu1, file=file1, status='OLD')

     call get_command_argument(2,file2)
     open(ignu2, file=file2, status='OLD')

     call get_command_argument(3,fileO)
     open(iout, file=fileO, status='unknown', position='append')
     

  else
     print *, "sytax:  extract_orderfile <datfile1>  <datfile2> <file_out>"
     stop
  endif
  
  nmax = 10000
  dmax = 100

  allocate(x(1:2, 1:3),  y(1:2, 1:3), xi(1:2,1:8, 1:3), yi(0:2,1:8, 1:3) )
  allocate(ip(1:2) )
  x = 0.
  y = 0.
  xi = 0.
  yi = 0.
  
  nn = 0
  ! order.dat file
  sum = 0.
  sum1 = 0.

  x0 = 0.32
  h0 = 0.02
  dmax = 8  
  ip = 0

  hh = h0 / dmax
  

  do k=1, 2  ! file index
     ip(k) = 0
     do i=1,nmax
        read(ignu0+k, *, end = 120) x(k, 1), y(k,1)
        read(ignu0+k, *, end = 120) x(k, 2), y(k,2)
        read(ignu0+k, *, end = 120) x(k, 3), y(k,3)

        
        if(x(k,1) >= x0 .and. x(k,3) <= x0+h0 .and. x(k,1) < x(k,3) ) then
           
           h = x(k,3) - x(k,1)


           !write(*,'(a3,i5, 30es12.4)') 'K', k, h, h0/2, h0/4, x(k,1), x(k,3)
           
           if( abs(h - h0/2) < 1E-5) then ! only two intervals
              ip(k) = ip(k) +  1
              xi(k, ip(k), 1) = x(k,1) + 0 * h
              call FUN(yi(k, ip(k), 1) , 0., y(k, 1), y(k, 2), y(k, 3) )
              call FUN(yi(k, ip(k), 2) , 0.125, y(k, 1), y(k, 2), y(k, 3) )
              call FUN(yi(k, ip(k), 3) , 0.25, y(k, 1), y(k, 2), y(k, 3) )
              
              ip(k) = ip(k) + 1
              xi(k, ip(k), 1) = x(k,1) + 0.25 * h
              call FUN(yi(k, ip(k), 1) , 0.25, y(k, 1), y(k, 2), y(k, 3) )
              call FUN(yi(k, ip(k), 2) , 0.375, y(k, 1), y(k, 2), y(k, 3) )
              call FUN(yi(k, ip(k), 3) , 0.5, y(k, 1), y(k, 2), y(k, 3) )

              ip(k) = ip(k) + 1
              xi(k, ip(k), 1) = x(k,1) + 0.50 * h
              call FUN(yi(k, ip(k), 1) , 0.5, y(k, 1), y(k, 2), y(k, 3) )
              call FUN(yi(k, ip(k), 2) , 0.625, y(k, 1), y(k, 2), y(k, 3) )
              call FUN(yi(k, ip(k), 3) , 0.75, y(k, 1), y(k, 2), y(k, 3) )

              ip(k) = ip(k) + 1
              xi(k, ip(k), 1) = x(k,1) + 0.75 * h
              call FUN(yi(k, ip(k), 1) , 0.75, y(k, 1), y(k, 2), y(k, 3) )
              call FUN(yi(k, ip(k), 2) , 0.875, y(k, 1), y(k, 2), y(k, 3) )
              call FUN(yi(k, ip(k), 3) , 1.00, y(k, 1), y(k, 2), y(k, 3) )

           else if( abs(h - h0/4) < 1E-5) then ! four intervals
              ip(k) = ip(k) +  1
              xi(k, ip(k), 1) = x(k,1) + 0 * h
              call FUN(yi(k, ip(k), 1) , 0., y(k, 1), y(k, 2), y(k, 3) )
              call FUN(yi(k, ip(k), 2) , 0.25, y(k, 1), y(k, 2), y(k, 3) )
              call FUN(yi(k, ip(k), 3) , 0.5, y(k, 1), y(k, 2), y(k, 3) )
              
              ip(k) = ip(k) + 1
              xi(k, ip(k), 1) = x(k,1) + 0.50 * h
              call FUN(yi(k, ip(k), 1) , 0.5,  y(k, 1), y(k, 2), y(k, 3) )
              call FUN(yi(k, ip(k), 2) , 0.75, y(k, 1), y(k, 2), y(k, 3) )
              call FUN(yi(k, ip(k), 3) , 1.0,  y(k, 1), y(k, 2), y(k, 3) )

           else if( abs(h - h0/8) < 1E-5) then ! eight intervals
              ip(k) = ip(k) +  1
              xi(k, ip(k), 1) = x(k,1) + 0 * h
              call FUN(yi(k, ip(k), 1) , 0., y(k, 1), y(k, 2), y(k, 3) )
              call FUN(yi(k, ip(k), 2) , 0.5, y(k, 1), y(k, 2), y(k, 3) )
              call FUN(yi(k, ip(k), 3) , 1.0, y(k, 1), y(k, 2), y(k, 3) )
           else
              print*,'TROUBLES 83hf383i'
              stop

           endif

        endif
     enddo ! i=1,nmax

              
        ! Simpson
!        val = ( (y(2, 1) - y(1, 1))**2 + 4 * (y(2, 2) - y(1, 2))**2  + (y(2, 3) - y(1, 3))**2 )/6.
!        val = val * abs(x(1,3) - x(1,1) )
!        
!        val1 = ( (y(2, 1) )**2 + 4 * (y(2, 2) )**2  + (y(2, 3) )**2 )/6.
!        val1 = val1 * abs(x(1,3) - x(1,1) )
!        sum = sum + val
!        sum1 = sum1 + val1

!        write(*,'(a8, 6es12.4)') 'SUM', val, val1, sum, sum1, sum/sum1
120  continue
  enddo ! k=1,2

  sum = 0.
  sum1 = 0.
  
  do k=1,2
     do i=1,dmax
        xi(k, i, 2) = xi(k, i, 1) + 0.5 * hh
        xi(k, i, 3) = xi(k, i, 1) + 1.0 * hh
        
        !write(*,'(a8,i5, 40es12.4)') 'INT',i, xi(k, i, 1:3), yi(k, i, 1:3)
        !write(100+k , *) xi(k, i, 1), yi(k, i, 1)
        !write(100+k , *) xi(k, i, 2), yi(k, i, 2)
        !write(100+k , *) xi(k, i, 3), yi(k, i, 3)
     enddo
  enddo
  
  sum = 0.
  sum1 = 0.

  yi(0, 1:dmax, 1:3) = ( yi(1, 1:dmax, 1:3) - yi(2, 1:dmax, 1:3) )

  do i=1,dmax
     ! Simpson
     val  = ( yi(0, i, 1)**2 + 4 * yi(0, i, 2)**2 + yi(0, i, 3)**2) / 6.
     val1 = ( yi(1, i, 1)**2 + 4 * yi(1, i, 2)**2 + yi(1, i, 3)**2) / 6.

     val = val * abs(xi(1, i, 3) - xi(1, i, 1) )
     val1 = val1 * abs(xi(1, i, 3) - xi(1, i, 1) )

     sum = sum + val
     sum1 = sum1 + val1
  enddo
  print*,'#####', sum, sum1, sum/sum1
  write(iout, *) sum/sum1, h
  close(iout)
  
end program diff_gnu_file



subroutine FUN(y, t, v0, v1, v2)
  real, intent(inout) :: y
  real, intent(in) :: t, v0, v1, v2

  y = 2. * v0 *(t-0.5) *(t-1) - 4.*v1*t*(t-1)  + 2.*v2*t*(t-0.5)

end subroutine FUN
