#!/bin/csh

if (  $#argv != 8) then
  echo "create_py_sol.sh <dir>  <n_min> <n_max>  <quants>  <other> <xlimits> <ylimits> <zlimits>"

else

    set dir = $argv[1]
    set min_mesh = $argv[2]
    set max_mesh = $argv[3]
    set quants = $argv[4]
    set others = $argv[5]
    set xlimits = $argv[6]
    set ylimits = $argv[7]
    set zlimits = $argv[8]

    if($quants == "none") then
      set quants = "  "
    endif
      
    if($others == "none") then
      set others = "  "
    endif
    
cat << EOF > tisk1.py

import numpy as np
import os
from colorPlotForAdgfem import plotSolutionWithAdaptation

######
'''
Main file for running script generating color plots of error estimators and hp- mesh
Needed files: 
	colorPlotForAdgfem.py - all routines 
	colormaps - file containing the color mappings
'''

# range of meshe indices which will be used
minMesh = $min_mesh
maxMesh = $max_mesh
meshRange = (minMesh, maxMesh)

#path = '../lopatka_test' # path to the directory when we computed the Adgfem results
path = '$dir'
direcName = 'color_images' # subfolder of "path" where the plots will be saved


adapt = True # TriA or Tri-+ files will be used as source
#adapt = False # TriA or Tri-+ files will be used as source
logscale = False # False = linear scale

# solution components: if ndim = 4, 1-4: primal solution, 5-8: adjoint solution
solIndices = [ $quants ]
#used  for lopatka
xLimits5 = [ $xlimits ]
yLimits5 = [ $ylimits ]
zLimits5 = [ $zlimits ]   # only for linear scale
limits5 = (xLimits5, yLimits5, zLimits5)

limits = [limits5]

# other quantities computed from the solution which can be plotted over the mesh
#machNumber = "mach"

otherQuantities = [ "$others" ]

# edgecolors - 'none' = no edges, 'k' = black
if (__name__ == "__main__"):
	plotSolutionWithAdaptation(solIndices, meshRange, path, direcName, adapt, limits, otherQuantities, edgecolors = 'none', logscale=logscale)
	print("Done.")


EOF

cp tisk1.py ../Scripts
python3 ../Scripts/tisk1.py

#cp tisk1.py ../../Scripts
#python3 ../../Scripts/tisk1.py


    endif

#    cd $dir/color_images
#    ~/GIT/adgfem/Scripts/gs_eps2png.sh 
#find . -name "*.eps" -exec epstopdf {} \;

    
