#!/bin/csh

if (  $#argv != 12) then
  echo "create_py_eta3.sh <dir>  <n_min> <n_max>  <quants>  <other> <xlimits> <ylimits> ... <maxP>"

else

    set dir = $argv[1]
    set min_mesh = $argv[2]
    set max_mesh = $argv[3]
    set quants = $argv[4]
    set others = $argv[5]
    set xlimitsA = $argv[6]
    set ylimitsA = $argv[7]
    set xlimitsB = $argv[8]
    set ylimitsB = $argv[9]
    set xlimitsC = $argv[10]
    set ylimitsC = $argv[11]
    set maxP = $argv[12]

    if($quants == "none") then
      set quants = "  "
    endif
      
    if($others == "none") then
      set others = "  "
    endif
    
cat << EOF > tisk1.py
import numpy as np 
import os
from colorPlotForAdgfem import readEtaFile, readMesh, \
	plotConst, plotConstWithLimits, plotEtaWithAdaptation

######
'''
Main file for running script generating color plots of error estimators and hp- mesh
Needed files: 
	colorPlotForAdgfem.py - all routines 
	colormaps - file containing the color mappings
'''

# range of meshe indices which will be used
minMesh = $min_mesh
maxMesh = $max_mesh
meshRange = (minMesh, maxMesh)

#path = '../lopatka_test' # path to the directory when we computed the Adgfem results
path = '$dir'
direcName = 'color_images' # subfolder of "path" where the plots will be saved

#       0			1 		2		3		7      , 29+
#etas = ['etaAver', 'etaS', 'etaD', 'etaA', 'etaAD', 'etaMark']
#etas = ['etaI', 'etaII']	# type of the estimates to plot ( given by indices in the elem%eta array )
etas = [  ]	# ONLY mesh
adapt = True # TriA or Tri-+ files will be used as source
hp = True  # plot also the hp mesh
maxHPPolDegree = $maxP

logscale = True # False = linear scale

xLimits5 = [ $xlimitsA ]
yLimits5 = [ $ylimitsA ]
zLimits5 = [ ]   # only for linear scale
limits5 = (xLimits5, yLimits5, zLimits5)

limits = [limits5]

xLimits6 = [ $xlimitsB ]
yLimits6 = [ $ylimitsB ]
zLimits6 = [ ]
limits6 = (xLimits6, yLimits6, zLimits6)

xLimits7 = [ $xlimitsC ]
yLimits7 = [ $ylimitsC ]
zLimits7 = [ ]
limits7 = (xLimits7, yLimits7, zLimits7)
# zLimit is not used for logscale !
limits = [limits5, limits6, limits7]

# edgecolors - 'none' = no edges, 'k' = black
if (__name__ == "__main__"):
	print("Running plotEtaWithAdaptation on path:", path)
	plotEtaWithAdaptation( etas, meshRange, path, direcName, adapt, limits, edgecolors = 'k', hp=hp, logscale=logscale, maxHPPolDegree=maxHPPolDegree)
	print("Done.")

EOF

cp tisk1.py ../Scripts
python3 ../Scripts/tisk1.py



    endif
