!> subroutines for plotting of 3D solutions
module plot_elem_mod
  use mesh_oper
  use main_data
  use integration
  use basis_mod
  use basis
  
  implicit none
  
contains




  !> 3D plot the actual solution
  subroutine PlotElemFunction3D(ifile, elem,  dof2, w)
    integer, intent(in) :: ifile        ! number of the file
    class(element), intent (in) :: elem     ! element where the basis is given
    integer, intent(in) :: dof2
    real, dimension(1:dof2), intent(in) :: w
    real, dimension(:,:), allocatable :: wi, xi, Fxi
    real, dimension(:,:,:), allocatable :: Dwi
    real, dimension(:,:,:), allocatable :: DphiT, Dphi
    type(Lagrang_rule), pointer :: L_rule
    integer :: Qnum, Qdof, Qdeg,  j, j1,j2, k, nface, it


    if (dof2 == 1) then
      nface = 1
    else
       nface = elem%deg +  1 !2  !4 !5
    endif


    L_rule => state%space%L_rule(nface)

    Qdeg = L_rule%Qdeg
    Qdof = L_rule%Qdof

    allocate(  xi(1:Qdof, 1:2), Fxi(1:Qdof, 1:2), wi(1:Qdof,1:ndim), Dwi(1:Qdof,1:ndim,0:nbDim) )

    xi(1:Qdof, 1:2) = L_rule%lambda(1:Qdof, 1:2)

    !if(ifile > 100) then
    !   print*,'#### ATTENTION in  PlotElemFunction3D !!!!!!!!!!!!!!!!!!!!!!'
    !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
    !    xi(1:Qdof, 1) = 4* xi(1:Qdof, 1) - 1. !
    !    xi(1:Qdof, 2) = 4* xi(1:Qdof, 2) - 1. !
    !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
    ! endif

    call ComputeF(elem, Qdof, xi(1:Qdof,1:nbDim), Fxi(1:Qdof,1:nbDim) )

    ! DG test functions in xi
    allocate( DphiT(1:dof2, 0:2, 1:Qdof) )  ! second index= 0 => phi, 1,2 => Dphi
    allocate( Dphi(1:dof2, 0:2, 1:Qdof) )  ! second index= 0 => phi, 1,2 => Dphi

    ! Dphi on reference element
    call PHI_orthonormal(Qdof, nbDim, xi(1:Qdof, 1:nbDim), 3, dof2, DphiT(1:dof2, 0, 1:Qdof), &
         Dphi(1:dof2, 1:2, 1:Qdof) )

    ! Dphi on real element
    call   Eval_Dphi_L_rule(nface, elem, dof2,  DphiT(1:dof2, 1:nbDim, 1:Qdof)  )

    !do j=1, dof2
    !   DphiT(j, 1, 1:Qdof) = &
    !        elem%F%D1F0(1,1) * Dphi(j, 1, 1:Qdof) &
    !        +elem%F%D1F0(1,2)* Dphi(j, 2, 1:Qdof)
    !
    !   DphiT(j, 2, 1:Qdof) = &
    !        elem%F%D1F0(2,1) * Dphi(j, 1, 1:Qdof) &
    !        +elem%F%D1F0(2,2)* Dphi(j, 2, 1:Qdof)
    !enddo

    do j=1,Qdof
       do k=1, 1 !!ndim
          wi(j, k) = dot_product(DphiT(1:dof2, 0, j), w(1 : dof2) )
          Dwi(j, k, 1) = dot_product(DphiT(1:dof2, 1, j), w(1 : dof2) )
          Dwi(j, k, 2) = dot_product(DphiT(1:dof2, 2, j), w(1 : dof2) )
          Dwi(j, k, 0) = sqrt( Dwi(j, k, 1)**2 +  Dwi(j, k, 2)**2)
       enddo
    enddo


    ! first orientation
    it= 0
    do j=0, Qdeg
       do k=0, Qdeg - j
          it = it + 1
          write(ifile, *) Fxi(it, 1:nbDim), wi(it, 1:ndim), &
               Dwi(it, 1:ndim, 0), Dwi(it, 1:ndim, 1), Dwi(it, 1:ndim, 2)
       enddo
       write(ifile,'(x)')
    enddo
    write(ifile,'(x)')

   ! second orientation
    do j=0, L_rule%Qdeg
       it = nface + 1 - j
       do k=0, L_rule%Qdeg - j
          write(ifile, *) Fxi(it, 1:nbDim), wi(it, 1:ndim), &
               Dwi(it, 1:ndim, 0), Dwi(it, 1:ndim, 1), Dwi(it, 1:ndim, 2)
          it = it + nface - k
       enddo
       write(ifile,'(x)')
    enddo
    write(ifile,'(x)')

    ! third orientation
    do j=0, L_rule%Qdeg
       it = j + 1
       do k=0, L_rule%Qdeg - j
          write(ifile, *) Fxi(it, 1:nbDim), wi(it, 1:ndim), &
               Dwi(it, 1:ndim, 0), Dwi(it, 1:ndim, 1), Dwi(it, 1:ndim, 2)
          it = it + nface +1 - k
       enddo
       write(ifile,'(x)')
    enddo
    write(ifile,'(x)')

    deallocate(xi, Fxi, wi, Dwi, Dphi, DphiT)


  end subroutine PlotElemFunction3D


  !> 3D plot the derivative of the actual solution
  subroutine PlotElem_D_Function3D(ifile, elem,  dof2, w)
    integer, intent(in) :: ifile        ! number of the file
    class(element), intent (in) :: elem     ! element where the basis is given
    integer, intent(in) :: dof2
    real, dimension(1:dof2), intent(in) :: w
    real, dimension(:,:), allocatable :: xi, Fxi
    real, dimension(:,:), allocatable :: wi
    real, dimension(:,:,:), allocatable :: Dwi
    real, dimension(:,:), allocatable :: phiT
    real, dimension(:,:,:), allocatable :: DphiT, Dphi
    type(Lagrang_rule), pointer :: L_rule
    integer :: Qnum, Qdof, Qdeg,  j, j1,j2, k, nface, it

    !print*,'elem%i', elem%i
    nface = elem%deg + 4 !5

    L_rule => state%space%L_rule(nface)

    Qdeg = L_rule%Qdeg
    Qdof = L_rule%Qdof

    allocate(  xi(1:Qdof, 1:2), Fxi(1:Qdof, 1:2), wi(1:Qdof,1:ndim), Dwi(1:Qdof,1:ndim,1:nbDim) )

    xi(1:Qdof, 1:2) = L_rule%lambda(1:Qdof, 1:2)

    call ComputeF(elem, Qdof, xi(1:Qdof,1:nbDim), Fxi(1:Qdof,1:nbDim) )

    ! DG test functions in xi
    allocate( phiT(1:dof2, 1:Qdof) )
    allocate( DphiT(1:dof2, 1:nbDim, 1:Qdof), Dphi(1:dof2, 1:nbDim, 1:Qdof) )

    call PHI_orthonormal(Qdof, nbDim, xi(1:Qdof, 1:nbDim), 3, dof2, phiT(1:dof2, 1:Qdof), &
         DphiT(1:dof2, 1:nbDim, 1:Qdof) )

    do j=1, dof2
       if( elem%F%iFlin) then
          Dphi(j, 1, 1:Qdof) = elem%F%D1F0(1,1) * DphiT(j, 1, 1:Qdof) &
               + elem%F%D1F0(1,2)* DphiT(j, 2, 1:Qdof)

          Dphi(j, 2, 1:Qdof) = elem%F%D1F0(2,1) * DphiT(j, 1, 1:Qdof) &
               + elem%F%D1F0(2,2)* DphiT(j, 2, 1:Qdof)
       else
          ! first index  in elem%F%V%D1F( *, , ) is only AN APPROXIMATION !!!!
          Dphi(j, 1, 1:Qdof) = elem%F%V%D1F(  1   ,1,1) * DphiT(j, 1, 1:Qdof) &
               + elem%F%V%D1F( 1  ,1,2)* DphiT(j, 2, 1:Qdof)

          Dphi(j, 2, 1:Qdof) = elem%F%V%D1F( 1 ,2,1) * DphiT(j, 1, 1:Qdof) &
               + elem%F%V%D1F( 1 ,2,2)* DphiT(j, 2, 1:Qdof)

       endif

    enddo

    do j=1,Qdof
       do k=1, 1 !!ndim
          wi(j, k) = dot_product(phiT(1:dof2, j), w(1 : dof2) )
          Dwi(j, k, 1) = dot_product(Dphi(1:dof2, 1, j), w(1 : dof2) )
          Dwi(j, k, 2) = dot_product(Dphi(1:dof2, 2, j), w(1 : dof2) )
       enddo
    enddo


    ! first orientation
    it= 0
    do j=0, Qdeg
       do k=0, Qdeg - j
          it = it + 1
          write(ifile, *) Fxi(it, 1:nbDim), wi(it, 1:1), Dwi(it, 1:1, 1), Dwi(it, 1:1, 2)
       enddo
       write(ifile,'(x)')
    enddo
    write(ifile,'(x)')

   ! second orientation
    do j=0, L_rule%Qdeg
       it = nface + 1 - j
       do k=0, L_rule%Qdeg - j
          write(ifile, *) Fxi(it, 1:nbDim), wi(it, 1:1), Dwi(it, 1:1, 1), Dwi(it, 1:1, 2)
          it = it + nface - k
       enddo
       write(ifile,'(x)')
    enddo
    write(ifile,'(x)')

    ! third orientation
    do j=0, L_rule%Qdeg
       it = j + 1
       do k=0, L_rule%Qdeg - j
          write(ifile, *) Fxi(it, 1:nbDim), wi(it, 1:1), Dwi(it, 1:1, 1), Dwi(it, 1:1, 2)
          it = it + nface +1 - k
       enddo
       write(ifile,'(x)')
    enddo
    write(ifile,'(x)')


    deallocate(xi, Fxi, wi, Dwi, phiT, DphiT, Dphi)


  end subroutine PlotElem_D_Function3D


  ! plot the function given by its Basis coefficients w(i), i=1,...,dof
  subroutine PlotElemFunctionB(ifile, elem, Zrule, dof,  w )
    class(element), intent (in) :: elem     ! element where the basis is given
    integer, intent(in) :: dof, ifile
    character, intent(in) :: Zrule
    real, dimension(1:dof), intent(in) :: w
    real, dimension(:,:), allocatable :: xi
    real, dimension(:,:), pointer :: phi
    integer :: Qnum, Qdof, i

    write(ifile,*) '#  Output file generated by PlotElemFunctionB subroutine'
    write(ifile,*) '# Qnum = ',elem%Qnum,',  Qdof = ',elem%Qdof

    Qdof = elem%Qdof
    Qnum = elem%Qnum

    allocate( xi(1:Qdof,1:nbDim) )

    call ComputeF(elem, Qdof, state%space%V_rule(Qnum)%lambda(1:Qdof,1:nbDim), &
         xi(1:Qdof,1:nbDim) )

    if(Zrule == 'V') then
       phi => state%space%V_rule(elem%Qnum)%phi(1:dof,1:Qdof)

    elseif(Zrule == 'L') then
       phi => state%space%L_rule(elem%Qnum)%phi(1:dof,1:Qdof)

    else
       print*,'Unknowb Zrule in eval_sol.f90'
       stop
    endif

    do i=1,Qdof
       write(ifile, *) xi(i, 1:nbDim), dot_product(w(1:dof), phi(1:dof,i) )
    enddo
    write(ifile,'(x)')

    deallocate(xi)

  end subroutine PlotElemFunctionB


  !> plot a function given by its values in integ nodes
  subroutine PlotElemFunctionQ(ifile, elem, Zrule, Qnum, Qdof,  wi )
    class(element), intent(in) :: elem
    integer, intent(in) :: Qdof, Qnum, ifile
    character, intent(in) :: Zrule
    real, dimension(1:Qdof), intent(in) :: wi
    real, dimension(:,:), pointer :: lambda
    real, dimension(:,:), allocatable :: xi
    integer :: i

    write(ifile,*) '#  Output file generated by PlotElemFunctionQ subroutine'

    if(Zrule == 'L') then
       lambda => state%space%L_rule(Qnum)%lambda(1:Qdof,1:nbDim)
    elseif(Zrule == 'V') then
       lambda => state%space%V_rule(Qnum)%lambda(1:Qdof,1:nbDim)
    else
       print*,'Unknown Zrule in eval_sol.f90'
       stop
    endif

    allocate(xi(1:Qdof, 1:nbDim))

    call ComputeF(elem, Qdof, lambda(1:Qdof,1:nbDim), xi(1:Qdof,1:nbDim) )

    do i=1,Qdof
       write(ifile, *) xi(i, 1:nbDim), wi(i), &
            2*(xi(i,1)*(1-xi(i,1))+xi(i,2)*(1-xi(i,2))), &
            wi(i) - 2*(xi(i,1)*(1-xi(i,1))+xi(i,2)*(1-xi(i,2)))
    enddo
    write(ifile,'(x)')
    write(ifile,'(x)')
    write(ifile,'(x)')

    deallocate(xi)

  end subroutine PlotElemFunctionQ

  ! plot the RTN function given by its Basis coefficients w(i), i=1,...,dof
  subroutine PlotElemRTNfunctionB(ifile, elem, Fdeg, Fdof,  w )
    class(element), intent (in) :: elem     ! element where the basis is given
    integer, intent(in) :: Fdof, ifile, Fdeg
    real, dimension(1:Fdof), intent(in) :: w
    real, dimension(:,:), allocatable :: xi
    real, dimension(:,:), pointer :: phi, phi1
    integer :: Qnum, Qdof, i

    write(*,*) ' PlotElemRTNfunctionB does not work, use of Piola trnasf is necessary'
    stop

    write(ifile,*) '#  Output file generated by PlotElemFunctionB subroutine'
    !write(ifile,*) '# Qnum = ',elem%Qnum,',  Qdof = ',elem%Qdof

    Qnum = state%RTN(Fdeg)%Qnum
    Qdof = state%RTN(Fdeg)%Qdof

    phi =>  state%RTN(Fdeg)%phi(1:Fdof,1, 0, 1:Qdof)
    phi1 => state%RTN(Fdeg)%phi(1:Fdof,2, 0, 1:Qdof)

    if(Fdof /= state%RTN(Fdeg)%dof) then
       print *,'Bad values in PlotElemRTNfunctionB  in eval_sol.f90'
       stop
    endif

    allocate( xi(1:Qdof,1:nbDim) )

    call ComputeF(elem, Qdof, state%space%V_rule(Qnum)%lambda(1:Qdof,1:nbDim), &
         xi(1:Qdof,1:nbDim) )

    do i=1,Qdof
       write(ifile, *) xi(i, 1:nbDim), dot_product(w(1:Fdof), phi(1:Fdof,i) ), &
            dot_product(w(1:Fdof), phi1(1:Fdof,i) )
    enddo
    write(ifile,'(x)')

    deallocate(xi)

  end subroutine PlotElemRTNfunctionB

end module plot_elem_mod
