module model_mod

 implicit none

 private

 type, public :: Model_t
   integer :: ndim
   real :: Re
   real :: Re1

   real :: kappa, kappa1                    ! problem parameters for NS only
   real :: Pr                           ! problem parameters for NS only
   real :: Pr_t                           ! problem parameters for NS only

   real :: cP                 ! heat capacity, constant pressure
   real :: cV                 ! heat capacity, constant volume

   ! type of dicretization of the slip BC for Euler equations
   ! 1) H(w) = p(w) (0,n1,n2,0)
   ! 2) H(w) = p( u_\Gamma(w)) (0,n1,n2,0) , where u_Gamma = UpdateMirror_W
   ! 3) H(w) = H_VS(w,\Mir(w),n), where \Mir = Mirror_W
   integer :: discretizationOfSlipBC_Euler

   ! parameter EUlerian
   real :: alpha
   real :: beta
   
!Parameters Javi needs
   real :: sigmak
   real :: sigmaw
   real :: betak
   real :: betaw
   real :: alphaw


   real :: p0                           ! problem parameters for Pedestrian (pedes) only
   real :: rho_char
   real :: g981

   !real:: v_max                       ! given in 'eikonal.f90', module PedestrianSettings
   !real:: rho_max
   !real :: alpha_ped
   real :: tau

   !SCALAR DATA
   integer :: icase                      ! index of the scalar problem
   integer :: idiff                      ! index of diffusion
   integer :: iconv                      ! index of convection
   integer :: ireac                      ! index of reaction
   integer :: iexact                     ! index of the exact solution + RHS
   real, dimension(1:2)  :: conv_rat     ! parameter for linearization of Jacobi, x and y coords
   real :: param1

   logical :: known_sol                    ! is the exact solution a priori known
   logical :: subdomainRHS              ! .true. = rhs is computed differently from the Set_Model_Data, only on a subdomain and possibly multiplied by dPhi/dx(?)
   integer :: rhsTestFunDerivative        ! RHS 0 = f*phi (implicitly), 1 = f * dPhi/dx, 2 = f * dPhi/dy
   logical :: convective                ! .true. = convective terms are presented
   logical :: varying_time_term         ! .true. = a function in front of the time derivative term
   logical :: precomputed_arrays         ! .true. = precomputed conductivity and capacity
   logical :: linear                    ! is the problem linear ?
   logical :: Lax_Friedrichs = .false.  ! Lax-Friedrichs numerical flux, only for scalar !!
   !NS DATA


!FERROR put the following here from state ???
  ! RHS_presented = .true.
  ! homogenDirichlet = .false.

 contains
   procedure :: initModel
  ! procedure :: printModel

   procedure :: init => initModel
 end type Model_t

 contains

 subroutine initModel ( this, Re, isca, t2)
    class (Model_t), intent(inout) :: this
    real, intent(in) ::Re
    integer, intent(in), optional :: isca
    real, intent(in), optional :: t2

   print*, 'Wrong call! Model is just an abstract type.'
   stop
   this%Re = Re
   this%convective = .true.
   this%varying_time_term = .false.     ! .true. = a function in front of the time derivative term
   this%precomputed_arrays = .false.    ! .true. capacity and conductivity precomputed
   this%linear = .false.
 end subroutine initModel

end module model_mod
