%% Logistic Method - Adams-Bashfort 2-step
%
% We solve the logistic problem
%
% $$x'=(1-x)*x, x(0)=2$$
%
% using Adams-Bashfort 2, Euler, and ode23

figure;
axis([0 3 1 2]);
hold on;
xlabel('t');
ylabel('x');
[t,x]=ab2(@logistic,0,3, 2, .1);
plot(t,x(:,1),'ro','DisplayName','Adams-Bashfort 2');

[t,x]=eul(@logistic,0,3, 2, .1);
plot(t,x(:,1),'b+','DisplayName','Euler');

[t,x]=ode23(@logistic,[0,3], 2);
plot(t,x(:,1),'k-','DisplayName','ode23');

legend('Location', 'NorthEast');


%% Linear Oscillator - Adams-Bashfort 2-step
%
% We solve linear oscillator with $a = 0$, $b = 9$, $c = 10$, $\omega = 1$
% and $x_0=(2,1)^T$ using Adams-Bashfort 2, Euler, and ode23.

figure
axis([0 10 -4 4]);
hold on;
xlabel('x_1');
ylabel('x_2');
[t,x]=ab2(@oscillator,0,10, [2;1], .1);
plot(t,x(:,1),'ro','DisplayName','Adams-Bashfort 2');

[t,x]=eul(@oscillator,0,10, [2;1], .1);
plot(t,x(:,1),'b+','DisplayName','Euler');

% compare with  ode23
[t,x]=ode23(@oscillator,[0,10], [2;1]);
plot(t,x(:,1),'k-','DisplayName','ode23');

legend('Location', 'NorthEast');

%% Linear Oscillator - Adams-Bashfort 3-step
%
% We solve linear oscillator with $a = 0$, $b = 9$, $c = 10$, $\omega = 1$
% and $x_0=(2,1)^T$ using Adams-Bashfort 2, Adams-Bashfort 3, and ode23.

figure
axis([0 10 -4 4]);
hold on;
xlabel('x_1');
ylabel('x_2');
[t,x]=ab2(@oscillator,0,10, [2;1], .1);
plot(t,x(:,1),'ro','DisplayName','Adams-Bashfort 2');

[t,x]=ab3(@oscillator,0,10, [2;1], .1);
plot(t,x(:,1),'b+','DisplayName','Adams-Bashfort 3');

% compare with  ode23
[t,x]=ode23(@oscillator,[0,10], [2;1]);
plot(t,x(:,1),'k-','DisplayName','ode23');

legend('Location', 'NorthEast');

%% Convergence Analysis for Adams-Bashfort
% We perform convergence analysis for 2-step and 3-step Adams-Bashfort

fprintf('Adams-Bashfort 2-step: = ');
conv_analysis(@ab2);
fprintf('Adams-Bashfort 3-step: = ');
conv_analysis(@ab3);
