function [t,x] = ab2(field, t0, T, x0, h)
%AB2 Implements the Adams-Bashfort two-step ODE solver
%
% Parameters:
%  field  -- Right hand side function of ODE system: x'=f(t,x)
%  t0     -- Initial time
%  T      -- End time (T > t0)
%  x0     -- Initial value
%  h      -- Size of time step (h <= T-t0)
%
% Outputs:
%  t  -- [t0; t-0+h, t0+2*h; ...; t0+i*h; ...]
%  x  -- Column vector containing numerical solution at each time step

m = 2;
n = ceil((T-t0)/h);

t = t0+h*(0:n).';
x = ones(n+1,length(x0));
[t(1:m), x(1:m,:)] = rk_classical(field, t0, t0+(m-1)*h, x0, h);

f1 = feval(field, t(m-1), x(m-1,:).');
for i=m:n
    f0 = feval(field, t(i), x(i,:).');
    x(i+1,:) = x(i,:).' + h*(3*f0-f1)/2;
    f1 = f0;
end