function h = dirfield(field, tmin, tmax, xmin, xmax)
% DIRFIELD Plots the direction field in the specified time and value range
%
% Arguments:
%    field     -- Function to plot the direction field for. Should take two
%                 arguments.
%    tmin,tmax -- Minimum and maximum value for time range to plot
%    xmin,xmax -- Minimum and maximum value for value range to plot

t = linspace(tmin, tmax, 10);
x = linspace(xmin, xmax, 10);

[T,X] = meshgrid(t, x);

[n,m] = size(X);

vt = ones(size(T));
vx = zeros(size(X));
for i = 1:n
    for j = 1:m
       vx(i,j) = feval(field, T(i,j), X(i,j));
    end
end
scale = sqrt(vx.^2 + vt.^2);
vx = vx./scale;
vt = vt./scale;
h = quiver(T, X, vt, vx, 'r');
axis image;
title('1D Direction Field');
xlabel('t');
ylabel('x');

end