function dxdt = catmouse(t, x, vm, vc)
% CATMOUSE Implements the ODE for the Cat in the Cat & Mouse simulation
%
% Parameters:
%  t  -- Time point to evaluate ODE at
%  x  -- Column vector of current position of Cat
%  vm -- Velocity of mouse
%  vc -- Velocity of cat

mousepos = [1-vm*t; 0];
dxdt = vc/norm(mousepos-x)*(mousepos-x);

end

