function dxdt = sat_ode(t,x)
% SAT_ODE Right hand side for the satellite ODE probel

mu = 1 / 82.45;

mustar = 1 - mu;
r13 = ((x(1) + mu)^2 + x(2)^2) ^ 1.5;
r23 = ((x(1) - mustar)^2 + x(2)^2) ^ 1.5;
dxdt = [ x(3)
         x(4)
         (2*x(4) + x(1) - mustar*((x(1)+mu)/r13) - mu*((x(1)-mustar)/r23))
         (-2*x(3) + x(2) - mustar*(x(2)/r13) - mu*(x(2)/r23)) ];



