function [t,x]=radauI2(field,t0,T,x0,h)
% RADAUI2 Implements the Lobatto3B implict RK method
%
% Butcher tableau
%   0 | 1/4  -1/4
% 2/3 | 1/4   5/12
% ----+-----------
%     | 1/4   3/4
%
% Parameters:
%  field  -- Right hand side function of ODE system: x'=f(t,x)
%  t0     -- Initial time
%  T      -- End time (T > t0)
%  x0     -- Initial value
%  h      -- Size of time step (h <= T-t0)
%
% Outputs:
%  t  -- [t0; t-0+h, t0+2*h; ...; t0+i*h; ...]
%  x  -- Matrix containing numerical solution, with each row the value of x
%        at each time step

tol=1e-10;

