function fig = plot_mesh(mesh, x)
%PLOT_MESH Plots the mesh that is returned by the FEM function
% and optionally the points for the DoFs
%
% Arguments:
%     mesh - Mesh returned from FEM
%     x    - Coordinates of DoFs to plot. Optional argument
%
% Return: Handle to the figure

fig = figure;
patch('Faces', mesh.elements, 'Vertices', mesh.vertices, ...
    'EdgeColor', 'b', 'FaceColor', 'none', 'LineWidth', 2);

if exist('x','var')
    hold on;
    scatter(x(:,1),x(:,2),20,'red','filled');
end
axis square;
xlabel('x');
ylabel('y');
end