function [DX, DY] = grad_basis_rotated_bilinear(X, Y)
%GARD_BASIS_ROTATED_BILINEAR Returns gradient of the rotated bilinear basis
% evaluated at points in reference square [-1,1]^2
%
% Arguments:
%     X - Vector of x-coordinates of points to evaluate
%     Y - Vector of y-coordinates of points to evaluate
%
% Returns:
%     DX - Nx4 matrix, where N is the number of points, containing per row
%          the four values of the derivatives of the basis w.r.t X
%          evaluated at the corresponding point. See basis_rotated_bilinear
%          for details on each basis point.
%     DY - Nx4 matrix containing the derivatives of the basis w.r.t Y

DX = zeros(length(X), 4);
DX(:,1) = 0.5+X/2;
DX(:,2) = -X/2;
DX(:,3) = -0.5+X/2;
DX(:,4) = -X/2;

DY = zeros(length(Y), 4);
DY(:,1) = -Y/2;
DY(:,2) = 0.5+Y/2;
DY(:,3) = -Y/2;
DY(:,4) = -0.5+Y/2;
end