function [DX, DY] = grad_basis_reduced_tri(p, X, Y)
%GRAD_BASIS_REDUCED_TRI Returns gradient of reduced 2-simplex basis 
%  evaluated at points in the reference triangle (-1,-1)-(1,-1)-(-1,1)
%
% Only p=3 supported.
%
% Arguments:
%     p - Polynomial degree of polynomial
%     X - Vector of x-coordinates of points to evaluate
%     Y - Vector of y-coordinates of points to evaluate
%
% Returns:
%     DX - Nx(3p) matrix, where N is the number of points,
%          containing per row the values of the derivatives of the basis
%          w.r.t. X evaluated at the corresponding point. See 
%          basis_reduced_tri for details on each basis point.
%     DY - Nx(3p) matrix containing derivatives of basis w.r.t Y
if p ~= 3
    error('Reduced basis on triangles must polynomial degree 3');
end
[LX, LY] = grad_basis_lagrange_tri(p, X, Y);
DX = combine_lagrange(p,LX);
DY = combine_lagrange(p,LY);
end

function Z = combine_lagrange(p,L)
Z = zeros(size(L,1), 3*p);
Z(:,1) = L(:,1)-L(:,10)/6;
Z(:,2) = L(:,2)-L(:,10)/6;
Z(:,3) = L(:,3)-L(:,10)/6;
Z(:,4) = L(:,4)+L(:,10)/4;
Z(:,5) = L(:,5)+L(:,10)/4;
Z(:,6) = L(:,6)+L(:,10)/4;
Z(:,7) = L(:,7)+L(:,10)/4;
Z(:,8) = L(:,8)+L(:,10)/4;
Z(:,9) = L(:,9)+L(:,10)/4;
end