function [DX, DY] = grad_basis_crouzeix_raviart(X, Y)
%GARD_BASIS_CROUZEIX_RAVIART Returns gradient of Crouzeix-Raviart basis
% evaluated at points in reference triangle (-1,1)-(1,-1)-(-1,1)
%
% Arguments:
%     X - Vector of x-coordinates of points to evaluate
%     Y - Vector of y-coordinates of points to evaluate
%
% Returns:
%     DX - Nx3 matrix, where N is the number of points, containing per row
%          the three values of the derivatives of the basis w.r.t X
%          evaluated at the corresponding point. See basis_crouzeix_raviart
%          for details on each basis point.
%     DY - Nx3 matrix containing the derivatices of the basis w.r.t Y

DX = zeros(length(X), 3);
DX(:,1) = 1;
DX(:,2) = -1;
DX(:,3) = 0;

DY = zeros(length(Y), 3);
DY(:,1) = 1;
DY(:,2) = 0;
DY(:,3) = -1;

end