function z = deriv_basis_lagrange_interval(p, x)
%DERIV_BASIS_LAGRANGE_INTERVAL Returns derivative of 1D Lagrange basis
% evaluated at points in the reference interval [-1,1]
%
% Arguments:
%     p - Polynomial degree of Lagrange polynomial
%     X - Vector of points to evaluate
%
% Returns:
%     Nx(p+1) matrix, where N is the number of points, containing per row
%     the values of the derivative of the basis evaluated at the
%     corresponding point.
%     The ith basis (for i = 0,...,p) corresponds to the point -1 + 2i/p

nodes = linspace(-1, 1, p+1);
denominator = ones(length(x), p+1);
numerator = zeros(length(x), p+1);
for i=1:p+1
    for j=1:p+1
        if j ~= i
            denominator(:,i) = denominator(:,i)*(nodes(i)-nodes(j));
            tmp = ones(size(x));
            for k=1:p+1
                if k ~= i && k ~= j
                    tmp = tmp.*(x - nodes(k));
                end
            end
            numerator(:,i) = numerator(:,i) + tmp;
        end
    end
end
z = numerator./denominator;

end