function Z = basis_rotated_bilinear(X, Y)
%BASIS_ROTATED_BILINEAR Returns rotated bilinear basis evaluated at points
% in reference square [-1,1]^2
%
% Arguments:
%     X - Vector of x-coordinates of points to evaluate
%     Y - Vector of y-coordinates of points to evaluate
%
% Returns:
%     Nx4 matrix, where N is the number of points, containing per row the
%     four values of the four basis evaluated at the corresponding point.
%     Each column corresponds to the basis for the nodes C1, C2, C3, C4
%     respectively, in the diagram below:
%
%                 C2
%      (-1,1) X---O---X (1,1)
%             |       |
%          C3 O       O C1
%             |       |
%     (-1,-1) X---O---X (1,-1) 
%                 C4

Z = zeros(length(X), 4);
phi = (X.^2-Y.^2);
Z(:,1) = 0.25+X/2+phi/4;
Z(:,2) = 0.25+Y/2-phi/4;
Z(:,3) = 0.25-X/2+phi/4;
Z(:,4) = 0.25-Y/2-phi/4;
end