function Z = basis_reduced_tri(p, X, Y)
%BASIS_REDUCED_TRI Returns reduced 2-simplex basis evaluated at points
% in the reference triangle (-1,-1)-(1,-1)-(-1,1)
%
% Only p=3 supported.
%
% Arguments:
%     p - Polynomial degree of Lagrange polynomial
%     X - Vector of x-coordinates of points to evaluate
%     Y - Vector of y-coordinates of points to evaluate
%
% Returns:
%     Nx(3p) matrix, where N is the number of points, containing
%     per row the values of the basis evaluated at the corresponding point.
%     The ordering of the basis points is as follows (this differs from the
%     lectures/practicals) - first the three vertices (as shown in the
%     diagram below); then all the basis for the first edge (E1)
%     left-to-right, then the second edge (E2) bottom-to-top, then E3
%     top-to-bottom (i.e., all edge DoFs counterclockwise from the
%     first vertex).
%
%      (-1,1) 3
%             |\
%             | \
%          E3 |  \ E2
%             |   \
%             |    \
%     (-1,-1) 1-----2 (1,-1) 
%                E1
if p ~= 3
    error('Reduced basis on triangles must polynomial degree 3');
end

Z = zeros(length(X), 3*p);
L = basis_lagrange_tri(p, X, Y);
Z(:,1) = L(:,1)-L(:,10)/6;
Z(:,2) = L(:,2)-L(:,10)/6;
Z(:,3) = L(:,3)-L(:,10)/6;
Z(:,4) = L(:,4)+L(:,10)/4;
Z(:,5) = L(:,5)+L(:,10)/4;
Z(:,6) = L(:,6)+L(:,10)/4;
Z(:,7) = L(:,7)+L(:,10)/4;
Z(:,8) = L(:,8)+L(:,10)/4;
Z(:,9) = L(:,9)+L(:,10)/4;
end