function z = basis_lagrange_interval(p, x)
%BASIS_LAGRANGE_INTERVAL Returns 1D Lagrange basis evaluated at points
% in the reference interval [-1,1]
%
% Arguments:
%     p - Polynomial degree of Lagrange polynomial
%     X - Vector of points to evaluate
%
% Returns:
%     Nx(p+1) matrix, where N is the number of points, containing per row
%     the values of the basis evaluated at the corresponding point.
%     The ith basis (for i = 0,...,p) corresponds to the point -1 + 2i/p

nodes = linspace(-1, 1, p+1);
z = ones(length(x), p+1);
for i=1:p+1
    for j=1:p+1
        if j ~= i
            z(:,i) = z(:,i).*(x - nodes(j))/(nodes(i) - nodes(j));
        end
    end
end

end