function Z = basis_crouzeix_raviart(X, Y)
%BASIS_CROUZEIX_RAVIART Returns Crouzeix-Raviart basis evaluated at points
% in reference triangle (-1,1)-(1,-1)-(-1,1)
%
% Arguments:
%     X - Vector of x-coordinates of points to evaluate
%     Y - Vector of y-coordinates of points to evaluate
%
% Returns:
%     Nx3 matrix, where N is the number of points, containing per row the
%     three values of the three basis evaluated at the corresponding point.
%     Each column corresponds to the basis for the nodes C1, C2, C3,
%     respectively, in the diagram below:
%
%      (-1,1) X
%             |\
%             | \
%          C2 O  O C1
%             |   \
%             |    \
%     (-1,-1) X--O--X (1,-1) 
%                C3

Z = zeros(length(X), 3);
Z(:,1) = 1+X+Y;
Z(:,2) = -X;
Z(:,3) = -Y;

end